/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.container;

import com.technicalitiesmc.lib.container.ExtendedContainer;
import com.technicalitiesmc.lib.container.fluid.FluidContainer;
import com.technicalitiesmc.lib.container.item.ItemContainer;
import com.technicalitiesmc.lib.container.item.adapter.ItemContainerToContainerAdapter;
import net.minecraftforge.fluids.FluidStack;

public class SimpleExtendedContainer
extends ItemContainerToContainerAdapter
implements ExtendedContainer {
    protected final FluidContainer fluidContainer;

    public SimpleExtendedContainer(ItemContainer itemContainer, FluidContainer fluidContainer) {
        super(itemContainer);
        this.fluidContainer = fluidContainer;
    }

    public ItemContainer getItemContainer() {
        return this.itemContainer;
    }

    public FluidContainer getFluidContainer() {
        return this.fluidContainer;
    }

    @Override
    public int getTanks() {
        return this.fluidContainer.size();
    }

    @Override
    public boolean areTanksEmpty() {
        return this.fluidContainer.isEmpty();
    }

    @Override
    public FluidStack getFluid(int tank) {
        return this.fluidContainer.get(tank);
    }

    @Override
    public FluidStack removeFluid(int tank, int amount) {
        FluidStack currentStack = this.fluidContainer.get(tank);
        FluidStack extracted = currentStack.copy();
        extracted.setAmount(Math.min(extracted.getAmount(), amount));
        FluidStack leftover = currentStack.copy();
        leftover.shrink(extracted.getAmount());
        this.fluidContainer.set(tank, leftover);
        return extracted;
    }

    @Override
    public void setFluid(int tank, FluidStack stack) {
        this.fluidContainer.set(tank, stack);
    }

    @Override
    public int getTankCapacity(int tank) {
        return this.fluidContainer.getCapacity(tank);
    }

    @Override
    public boolean canPlaceFluid(int tank, FluidStack stack) {
        return this.fluidContainer.isValid(tank, stack);
    }
}

